
/*
  CLASSiC DAC, Copyright 2013 SILICON CHIP Publications
  CS8416.c: functions to communicate with and configure the CS8416 digital audio receiver IC via SPI
  Written by Nicholas Vinen, 2012-2013
*/

#include "CS8416.h"
#include "Control_SPI.h"
#include "p33Fxxxx.h"
#include "Timer.h"

void CS8416_Setup() {
  LATDbits.LATD2 = 0;
  TRISDbits.TRISD2 = 0;
  Timer_Delay_ms(1);
  LATDbits.LATD2 = 1;
}

void CS8416_HoldInReset() {
  LATDbits.LATD2 = 0;
  TRISDbits.TRISD2 = 0;
}

void CS8416_Write_Register(unsigned char addr, unsigned char data) {
  unsigned short cmd = 0x2000 | addr;

  asm volatile("disi #0x3fff");
  LATCbits.LATC2 = 0;
  SPI_Transfer_Word(cmd);
  SPI_Set_Word_Length(8);
  SPI_Transfer_Word(data);
  SPI_Set_Word_Length(16);
  LATCbits.LATC2 = 1;
  asm volatile("disi #0");
}

unsigned char CS8416_Read_Register(unsigned char addr) {
  unsigned short cmd = 0x2000 | addr;
  unsigned char ret;

  asm volatile("disi #0x3fff");
  LATCbits.LATC2 = 0;
  SPI_Transfer_Word(cmd);
  LATCbits.LATC2 = 1;
  Timer_Delay_us(1);
  LATCbits.LATC2 = 0;
  ret = SPI_Transfer_Word(0x2100);
  LATCbits.LATC2 = 1;
  asm volatile("disi #0");
  return ret;
}

void CS8416_Write_Registers(unsigned char addr, const unsigned char* data, unsigned char num) {
  unsigned short cmd = 0x2080 | addr;

  LATCbits.LATC2 = 0;
  SPI_Transfer_Word(cmd);
  while( num > 1 ) {
    SPI_Transfer_Word( (((unsigned short)data[0])<<8) | data[1] );
    data += 2;
    num -= 2;
  }
  if( num ) {
    SPI_Set_Word_Length(8);
    SPI_Transfer_Word(data[0]);
    SPI_Set_Word_Length(16);
  }
  LATCbits.LATC2 = 1;
}

void CS8416_Read_Registers(unsigned char addr, unsigned char* data, unsigned char num) {
  unsigned short cmd = 0x2180 | addr;
  unsigned short temp;

  LATCbits.LATC2 = 0;
  SPI_Transfer_Word(cmd);
  LATCbits.LATC2 = 1;
  Timer_Delay_us(1);
  LATCbits.LATC2 = 0;
  while( num > 1 ) {
    temp = SPI_Transfer_Word(0);
    data[0] = temp>>8;
    data[1] = temp;
    data += 2;
    num -= 2;
  }
  if( num ) {
    SPI_Set_Word_Length(8);
    data[0] = SPI_Transfer_Word(0);
    SPI_Set_Word_Length(16);
  }
  LATCbits.LATC2 = 1;
}

bool CS8416_Verify_ID() {
  return (CS8416_Read_Register(CS8416_REG_ID_AND_VERSION)&0xF0) == CS8416_ID;
}
